'''''''''''''''''''''
' Image Creator.bas '
'''''''''''''''''''''
'
'
' Written by Justin Richards
'
' This program was created to make images for my 2d platform games.  It works
' similarly to MSPaint, allowing you to draw, flip, rotate, resize, load and
' save images into the .gfx format required for the games.  It uses the
' standard 256 colour mode in qbasic so if you want to change the palette you
' will need to modify the program accordingly.
'
'
' This program is free and I wish it to be used by anyone who needs it, only
' asking those who do to include me in the credits of their own creations.
'
' Enjoy!
'
' Justin Richards
'
'
' P.S. I haven't commented and explained this one as of yet, when I get more
' time I will do this, also there are a few known bugs in it, mainly due to
' the mouse code.  Once again, when I get time I will fix these aswell...


TYPE GraphicsType

  PX AS STRING * 2
  PY AS STRING * 2
  PCO AS STRING * 3

END TYPE

DIM SHARED GT AS GraphicsType


ON ERROR GOTO Errors

FileName$ = "NewImage.gfx"
SourceFolder$ = "Resources\"

GTIncrement = 7

CHDIR "NewGame"

ImageSize = 40


CLS
SCREEN _NEWIMAGE(320, 200, 256)
_FULLSCREEN

_MOUSESHOW

GOSUB BackGround

GOSUB Buttons

PrintCo = 15

Co1X = 10: Co1Y = 65: Co1 = 0
Co2X = 74: Co2Y = 65: Co2 = 8

LINE (Co1X - 2, Co1Y - 2)-(Co1X + 6, Co1Y + 6), 15, B
LINE (Co2X - 2, Co2Y - 2)-(Co2X + 6, Co2Y + 6), 40, B

DO

  IF Delay = 5 THEN Delay = 0
  Delay = Delay + 1

  IF Delay = 5 THEN

    IF PrintCo = 15 THEN LOCATE 1, 20: PRINT "            "
    IF PrintCo = 15 THEN LOCATE 1, 20: COLOR PrintCo: PRINT FileName$

    PrintCo = 15

    LOCATE 1, 35: PRINT Co1
    IF Co1 < 100 THEN LOCATE 1, 38: PRINT " "


    DO

      IF _MOUSEX < 312 AND _MOUSEY < 182 AND _MOUSEX > 148 AND _MOUSEY > 18 THEN

        IF _MOUSEBUTTON(1) THEN

          PaintX = INT((_MOUSEX - 150) / 4)
          PaintY = INT((_MOUSEY - 20) / 4)

          PaintX = PaintX * 4 + 151
          PaintY = PaintY * 4 + 20

          IF PaintX > 150 AND PaintX < 309 AND PaintY > 19 AND PaintY < 179 THEN LINE (PaintX, PaintY)-(PaintX + 2, PaintY + 2), Co1, BF

        END IF

        IF _MOUSEBUTTON(2) THEN

          PaintX = INT((_MOUSEX - 150) / 4)
          PaintY = INT((_MOUSEY - 20) / 4)

          PaintX = PaintX * 4 + 151
          PaintY = PaintY * 4 + 20

          IF PaintX > 150 AND PaintX < 309 AND PaintY > 19 AND PaintY < 179 THEN LINE (PaintX, PaintY)-(PaintX + 2, PaintY + 2), Co2, BF

        END IF

      END IF

      IF _MOUSEX < 137 AND _MOUSEY < 192 AND _MOUSEX > 8 AND _MOUSEY > 63 THEN

        IF _MOUSEBUTTON(1) THEN

          LINE (Co1X - 2, Co1Y - 2)-(Co1X + 6, Co1Y + 6), 0, B
          LINE (Co2X - 2, Co2Y - 2)-(Co2X + 6, Co2Y + 6), 40, B

          Co1X = INT((_MOUSEX - 9) / 8)
          Co1Y = INT((_MOUSEY - 64) / 8)

          Co1X = Co1X * 8 + 10
          Co1Y = Co1Y * 8 + 65
          Co1 = POINT(Co1X, Co1Y)

          LINE (Co1X - 2, Co1Y - 2)-(Co1X + 6, Co1Y + 6), 15, B

        END IF

        IF _MOUSEBUTTON(2) THEN

          LINE (Co2X - 2, Co2Y - 2)-(Co2X + 6, Co2Y + 6), 0, B
          LINE (Co1X - 2, Co1Y - 2)-(Co1X + 6, Co1Y + 6), 15, B

          Co2X = INT((_MOUSEX - 9) / 8)
          Co2Y = INT((_MOUSEY - 64) / 8)

          Co2X = Co2X * 8 + 10
          Co2Y = Co2Y * 8 + 65
          Co2 = POINT(Co2X, Co2Y)

          LINE (Co2X - 2, Co2Y - 2)-(Co2X + 6, Co2Y + 6), 40, B

        END IF

      END IF

      IF _MOUSEX > 64 AND _MOUSEX < 85 AND _MOUSEY > 9 AND _MOUSEY < 25 THEN

        PrintCo = 14

        LOCATE 1, 20: COLOR PrintCo: PRINT "New / Erase        "

        IF _MOUSEBUTTON(1) THEN

          CLOSE #1

          ' Save Current image to temp file just in case...

          IF _FILEEXISTS(SourceFolder$ + "temp.gfx") THEN KILL SourceFolder$ + "temp.gfx"

          OPEN SourceFolder$ + "temp.gfx" FOR BINARY AS 1 LEN = LEN(GT)

          LoopIncrement = -GTIncrement

          FOR PointY = 10 TO ImageSize + 9

            FOR PointX = 10 TO ImageSize + 9

              PointCo = POINT(PointX, PointY)

              GT.PX = LTRIM$(STR$(PointX - 10))
              GT.PY = LTRIM$(STR$(PointY - 10))
              GT.PCO = LTRIM$(STR$(PointCo))

              PUT #1, LoopIncrement + GTIncrement + 1, GT

              LoopIncrement = LoopIncrement + GTIncrement

            NEXT PointX

          NEXT PointY

          FileName$ = "NewImage.gfx"

          GOSUB BackGround
          GOSUB Buttons

          LINE (Co1X - 2, Co1Y - 2)-(Co1X + 6, Co1Y + 6), 15, B
          LINE (Co2X - 2, Co2Y - 2)-(Co2X + 6, Co2Y + 6), 40, B

        END IF

      END IF

      IF _MOUSEX > 89 AND _MOUSEX < 110 AND _MOUSEY > 9 AND _MOUSEY < 25 THEN

        PrintCo = 10

        LOCATE 1, 20: COLOR PrintCo: PRINT "Save Image         "

        IF _MOUSEBUTTON(1) THEN

          LINE (20, 85)-(299, 124), 20, BF
          LINE (21, 86)-(298, 123), 22, BF
          LINE (24, 89)-(295, 120), 20, BF
          LINE (25, 90)-(294, 119), 0, BF

          OldFileName$ = FileName$

          LOCATE 7, 5: INPUT " Save as: ", FileName$

          IF _FILEEXISTS(SourceFolder$ + FileName$) THEN

            LINE (20, 85)-(299, 124), 20, BF
            LINE (21, 86)-(298, 123), 22, BF
            LINE (24, 89)-(295, 120), 20, BF
            LINE (25, 90)-(294, 119), 0, BF

            LOCATE 7, 5: INPUT " Overwrite? (y/n)", OverWrite$

            IF OverWrite$ = "y" OR OverWrite$ = "Y" THEN

              KILL SourceFolder$ + FileName$

            ELSE

              FileName$ = OldFileName$

              GOSUB BackGround
              GOSUB Buttons

              LOCATE 1, 20: COLOR 40: PRINT "Save Cancelled     "

              LINE (Co1X - 2, Co1Y - 2)-(Co1X + 6, Co1Y + 6), 15, B
              LINE (Co2X - 2, Co2Y - 2)-(Co2X + 6, Co2Y + 6), 40, B

              GOTO gtNoSave

            END IF

          END IF

          CLOSE #1

          OPEN SourceFolder$ + FileName$ FOR BINARY AS 1 LEN = LEN(GT)

          LoopIncrement = -GTIncrement

          FOR PointY = 10 TO ImageSize + 9

            FOR PointX = 10 TO ImageSize + 9

              PointCo = POINT(PointX, PointY)

              GT.PX = LTRIM$(STR$(PointX - 10))
              GT.PY = LTRIM$(STR$(PointY - 10))
              GT.PCO = LTRIM$(STR$(PointCo))

              PUT #1, LoopIncrement + GTIncrement + 1, GT

              LoopIncrement = LoopIncrement + GTIncrement

            NEXT PointX

          NEXT PointY

          GOSUB BackGround
          GOSUB Buttons

          LINE (Co1X - 2, Co1Y - 2)-(Co1X + 6, Co1Y + 6), 15, B
          LINE (Co2X - 2, Co2Y - 2)-(Co2X + 6, Co2Y + 6), 40, B



          ' Read Graphics file and Draw the Image...


          ' Find the last record in the file to determine image dimensions...

          LoopIncrement = LOF(1)

          GET #1, LoopIncrement - GTIncrement + 1, GT

          PointX = VAL(GT.PX)
          PointY = VAL(GT.PY)


          ' Draw the Image on the screen with the background

          LoopIncrement = -GTIncrement

          FOR DrawY = 0 TO PointX

            FOR DrawX = 0 TO PointY

              GET #1, LoopIncrement + GTIncrement + 1, GT

              PointCo = VAL(GT.PCO)

              PSET (DrawX + 10, DrawY + 10), PointCo
              LINE (DrawX * 4 + 151, DrawY * 4 + 20)-(DrawX * 4 + 153, DrawY * 4 + 22), PointCo, BF

              LoopIncrement = LoopIncrement + GTIncrement

            NEXT DrawX

          NEXT DrawY

        END IF

        gtNoSave:

      END IF

      IF _MOUSEX > 114 AND _MOUSEX < 135 AND _MOUSEY > 9 AND _MOUSEY < 25 THEN

        PrintCo = 13

        LOCATE 1, 20: COLOR PrintCo: PRINT "Load Image         "

        IF _MOUSEBUTTON(1) THEN

          LINE (20, 85)-(299, 124), 20, BF
          LINE (21, 86)-(298, 123), 22, BF
          LINE (24, 89)-(295, 120), 20, BF
          LINE (25, 90)-(294, 119), 0, BF

          OldFileName$ = FileName$

          LOCATE 7, 5: INPUT " Load File: ", FileName$

          IF _FILEEXISTS(SourceFolder$ + FileName$) THEN

            CLOSE #1

            OPEN SourceFolder$ + FileName$ FOR BINARY AS 1 LEN = LEN(GT)

          ELSE

            FileName$ = OldFileName$

            GOSUB BackGround
            GOSUB Buttons

            LOCATE 1, 20: COLOR PrintCo: PRINT "No File to Load    "

            LINE (Co1X - 2, Co1Y - 2)-(Co1X + 6, Co1Y + 6), 15, B
            LINE (Co2X - 2, Co2Y - 2)-(Co2X + 6, Co2Y + 6), 40, B

            GOTO gtNoLoad

          END IF

          ' Read Graphics file and Draw the Image...

          ' Find the last record in the file to determine image dimensions...

          LoopIncrement = LOF(1)

          IF LoopIncrement = 11200 THEN ImageSize = 40
          IF LoopIncrement = 6300 THEN ImageSize = 30
          IF LoopIncrement = 2800 THEN ImageSize = 20
          IF LoopIncrement = 700 THEN ImageSize = 10

          GOSUB BackGround
          GOSUB Buttons

          LINE (Co1X - 2, Co1Y - 2)-(Co1X + 6, Co1Y + 6), 15, B
          LINE (Co2X - 2, Co2Y - 2)-(Co2X + 6, Co2Y + 6), 40, B

          GET #1, LoopIncrement - GTIncrement + 1, GT

          PointX = VAL(GT.PX)
          PointY = VAL(GT.PY)


          ' Draw the Image on the screen with the background

          LoopIncrement = -GTIncrement

          FOR DrawY = 0 TO PointX

            FOR DrawX = 0 TO PointY

              GET #1, LoopIncrement + GTIncrement + 1, GT

              PointCo = VAL(GT.PCO)

              PSET (DrawX + 10, DrawY + 10), PointCo
              LINE (DrawX * 4 + 151, DrawY * 4 + 20)-(DrawX * 4 + 153, DrawY * 4 + 22), PointCo, BF

              LoopIncrement = LoopIncrement + GTIncrement

            NEXT DrawX

          NEXT DrawY

        END IF

        gtNoLoad:

      END IF

      IF _MOUSEX > 64 AND _MOUSEX < 85 AND _MOUSEY > 34 AND _MOUSEY < 50 THEN

        PrintCo = 43

        LOCATE 1, 20: COLOR PrintCo: PRINT "Rotate Image       "

        IF _MOUSEBUTTON(1) THEN

          CLOSE #1

          IF _FILEEXISTS(SourceFolder$ + "temp.gfx") THEN KILL SourceFolder$ + "temp.gfx"

          OPEN SourceFolder$ + "temp.gfx" FOR BINARY AS 1 LEN = LEN(GT)

          LoopIncrement = -GTIncrement

          FOR PointY = 10 TO ImageSize + 9

            FOR PointX = 10 TO ImageSize + 9

              PointCo = POINT(PointX, PointY)

              GT.PX = LTRIM$(STR$(PointX - 10))
              GT.PY = LTRIM$(STR$(PointY - 10))
              GT.PCO = LTRIM$(STR$(PointCo))

              PUT #1, LoopIncrement + GTIncrement + 1, GT

              LoopIncrement = LoopIncrement + GTIncrement

            NEXT PointX

          NEXT PointY

          GOSUB BackGround
          GOSUB Buttons

          LINE (Co1X - 2, Co1Y - 2)-(Co1X + 6, Co1Y + 6), 15, B
          LINE (Co2X - 2, Co2Y - 2)-(Co2X + 6, Co2Y + 6), 40, B


          ' Read Graphics file and Draw the Image rotated...


          ' Find the last record in the file to determine image dimensions...

          LoopIncrement = LOF(1)

          GET #1, LoopIncrement - GTIncrement + 1, GT

          PointX = VAL(GT.PX)
          PointY = VAL(GT.PY)


          ' Draw the Image on the screen with the background

          LoopIncrement = -GTIncrement

          FOR DrawY = PointY TO 0 STEP -1

            FOR DrawX = 0 TO PointX

              GET #1, LoopIncrement + GTIncrement + 1, GT

              PointCo = VAL(GT.PCO)

              PSET (DrawY + 10, DrawX + 10), PointCo
              LINE (DrawY * 4 + 151, DrawX * 4 + 20)-(DrawY * 4 + 153, DrawX * 4 + 22), PointCo, BF

              LoopIncrement = LoopIncrement + GTIncrement

            NEXT DrawX

          NEXT DrawY

        END IF

      END IF

      IF _MOUSEX > 89 AND _MOUSEX < 110 AND _MOUSEY > 34 AND _MOUSEY < 50 THEN

        PrintCo = 11

        LOCATE 1, 20: COLOR PrintCo: PRINT "Flip Image         "

        IF _MOUSEBUTTON(1) THEN

          CLOSE #1

          IF _FILEEXISTS(SourceFolder$ + "temp.gfx") THEN KILL SourceFolder$ + "temp.gfx"

          OPEN SourceFolder$ + "temp.gfx" FOR BINARY AS 1 LEN = LEN(GT)

          LoopIncrement = -GTIncrement

          FOR PointY = 10 TO ImageSize + 9

            FOR PointX = 10 TO ImageSize + 9

              PointCo = POINT(PointX, PointY)

              GT.PX = LTRIM$(STR$(PointX - 10))
              GT.PY = LTRIM$(STR$(PointY - 10))
              GT.PCO = LTRIM$(STR$(PointCo))

              PUT #1, LoopIncrement + GTIncrement + 1, GT

              LoopIncrement = LoopIncrement + GTIncrement

            NEXT PointX

          NEXT PointY

          GOSUB BackGround
          GOSUB Buttons

          LINE (Co1X - 2, Co1Y - 2)-(Co1X + 6, Co1Y + 6), 15, B
          LINE (Co2X - 2, Co2Y - 2)-(Co2X + 6, Co2Y + 6), 40, B


          ' Read Graphics file and Draw the Image backwards...


          ' Find the last record in the file to determine image dimensions...

          LoopIncrement = LOF(1)

          GET #1, LoopIncrement - GTIncrement + 1, GT

          PointX = VAL(GT.PX)
          PointY = VAL(GT.PY)


          ' Draw the Image on the screen with the background

          LoopIncrement = -GTIncrement

          FOR DrawY = 0 TO PointY

            FOR DrawX = PointX TO 0 STEP -1

              GET #1, LoopIncrement + GTIncrement + 1, GT

              PointCo = VAL(GT.PCO)

              PSET (DrawX + 10, DrawY + 10), PointCo
              LINE (DrawX * 4 + 151, DrawY * 4 + 20)-(DrawX * 4 + 153, DrawY * 4 + 22), PointCo, BF

              LoopIncrement = LoopIncrement + GTIncrement

            NEXT DrawX

          NEXT DrawY

        END IF

      END IF

      IF _MOUSEX > 114 AND _MOUSEX < 135 AND _MOUSEY > 34 AND _MOUSEY < 50 THEN

        PrintCo = 32

        LOCATE 1, 20: COLOR PrintCo: PRINT "Image Size         "

        IF _MOUSEBUTTON(1) THEN

          IF ImageSize = 40 THEN ImageSize = 0
          ImageSize = ImageSize + 10

          GOSUB BackGround
          GOSUB Buttons

          LINE (Co1X - 2, Co1Y - 2)-(Co1X + 6, Co1Y + 6), 15, B
          LINE (Co2X - 2, Co2Y - 2)-(Co2X + 6, Co2Y + 6), 40, B

        END IF

      END IF

    LOOP WHILE _MOUSEINPUT

    FOR GridY = 21 TO 177 STEP 4

      FOR GridX = 151 TO 307 STEP 4

        GridCo = POINT(GridX, GridY)

        PreviewX = INT((GridX - 150) / 4) + 10
        PreviewY = INT((GridY - 20) / 4) + 10

        PSET (PreviewX, PreviewY), GridCo

      NEXT GridX

    NEXT GridY

  END IF

  _LIMIT 10

  _DISPLAY

LOOP UNTIL INKEY$ = CHR$(27)

Errors:

SYSTEM

BackGround:

CLS

LINE (0, 0)-(144, 4), 28, BF
LINE (0, 0)-(4, 199), 28, BF
LINE (0, 195)-(319, 199), 28, BF
LINE (315, 0)-(319, 199), 28, BF

LINE (55, 0)-(59, 59), 28, BF

LINE (140, 0)-(144, 199), 28, BF

LINE (0, 55)-(144, 59), 28, BF

LINE (1, 1)-(143, 3), 30, BF
LINE (1, 1)-(3, 198), 30, BF
LINE (1, 196)-(318, 198), 30, BF
LINE (316, 1)-(318, 198), 30, BF

LINE (141, 1)-(143, 198), 30, BF

LINE (56, 1)-(58, 58), 30, BF

LINE (1, 56)-(143, 58), 30, BF


LINE (150, 20)-(149 + (ImageSize * 4), 19 + (ImageSize * 4)), 8, BF

LINE (150, 19)-(150 + (ImageSize * 4), 19), 22
LINE (150 + (ImageSize * 4), 19)-(150 + (ImageSize * 4), 19 + (ImageSize * 4)), 22

FOR a = 150 TO 149 + (ImageSize * 4) STEP 4

  FOR b = 20 TO 19 + (ImageSize * 4) STEP 4

    LINE (a, b)-(a, b + 3), 22
    LINE (a, b + 3)-(a + 3, b + 3), 22

  NEXT b

NEXT a

LINE (10, 10)-(49, 49), 8, BF

FOR b = 64 TO 184 STEP 8

  FOR a = 9 TO 129 STEP 8

    LINE (a, b)-(a + 6, b + 6), Co, BF

    Co = Co + 1

  NEXT a

NEXT b

RETURN



Buttons:

FOR By = 10 TO 35 STEP 25

  FOR Bx = 65 TO 115 STEP 25

    LINE (Bx, By)-(Bx + 19, By + 14), 18, BF

    PSET (Bx, By), 0
    PSET (Bx, By + 14), 0
    PSET (Bx + 19, By), 0
    PSET (Bx + 19, By + 14), 0


    LINE (Bx + 2, By + 2)-(Bx + 17, By + 12), 20, BF

    PSET (Bx + 2, By + 2), 18
    PSET (Bx + 2, By + 12), 18
    PSET (Bx + 17, By + 2), 18
    PSET (Bx + 17, By + 12), 18


  NEXT Bx

  LINE (70, 13)-(71, 21), 14, B
  LINE (78, 13)-(79, 21), 14, B
  LINE (71, 13)-(78, 20), 14
  LINE (71, 14)-(78, 21), 14

  LINE (95, 13)-(104, 14), 10, B
  LINE (95, 13)-(96, 17), 10, B
  LINE (95, 17)-(104, 17), 10
  LINE (103, 17)-(104, 21), 10, B
  LINE (95, 20)-(104, 21), 10, B

  LINE (120, 13)-(121, 21), 13, B
  LINE (120, 20)-(129, 21), 13, B

  LINE (70, 38)-(79, 42), 43, B
  LINE (71, 39)-(78, 41), 43, B
  LINE (70, 43)-(71, 46), 43, B
  LINE (77, 43)-(78, 44), 43, B
  LINE (78, 45)-(79, 46), 43, B

  LINE (95, 38)-(104, 39), 11, B
  LINE (95, 38)-(96, 46), 11, B
  LINE (95, 42)-(102, 42), 11

  IF ImageSize = 40 THEN

    LINE (120, 38)-(120, 44), 32
    LINE (120, 43)-(123, 44), 32, B
    LINE (122, 45)-(122, 46), 32

  END IF

  IF ImageSize = 30 THEN

    LINE (120, 38)-(123, 39), 32, B
    LINE (121, 42)-(123, 42), 32
    LINE (120, 46)-(123, 45), 32, B
    LINE (122, 38)-(123, 46), 32, BF

  END IF

  IF ImageSize = 20 THEN

    LINE (120, 38)-(123, 39), 32, B
    LINE (121, 42)-(123, 42), 32
    LINE (120, 46)-(123, 45), 32, B
    LINE (122, 38)-(123, 42), 32, BF
    LINE (120, 42)-(121, 46), 32, BF

  END IF

  IF ImageSize = 10 THEN

    LINE (121, 38)-(122, 46), 32, BF

  END IF

  LINE (125, 38)-(129, 46), 32, B
  LINE (126, 39)-(128, 45), 32, B

NEXT By


RETURN
